#!/bin/sh
#
# File: mmDeltaRestore.sh
# Desc: This script will do restore from a previous backup done by the mmDeltaBackup.sh script
#
# In order for us to do a restore we need to have a full.tgz backup file along with 
# relevant delta files
#

if [ $# -lt 1 ]
then
	echo "Usage: mmDeltaRestore.sh <backup path>"
	exit 1
fi

DESTINATION=$1

FULL_BACKUP_NAME=full.tgz
FULL_BACKUP_PATH=$DESTINATION/$FULL_BACKUP_NAME

REF_NAME=ref
REF_PATH=$DESTINATION/$REF_NAME

if [ ! -f "$FULL_BACKUP_PATH" ]
then
	echo "No full backup found, please verify that $FULL_BACKUP_NAME exist in the given backup directory"
	exit 2
fi

# Make sure that backup directory can only be read by us.
chmod 700 $DESTINATION

# Clean up to avoid conflicts.
rm -rf $REF_PATH

# Extract full backup.
tar -xzf $DESTINATION/$FULL_BACKUP_NAME -C $DESTINATION

# Apply delta changes.
DELTA_BACKUP_NAME=delta
for i in $(seq 1 2000)
do
	new=$(printf "%d" ${i})
	DELTA_SEQ_FILE=$DELTA_BACKUP_NAME$new
	DELTA_SEQ_PATH=$DESTINATION/$DELTA_SEQ_FILE
	if [ -f "$DELTA_SEQ_PATH" ]
	then
		rsync -a --log-file=/var/log/rsync.log --read-batch=$DELTA_SEQ_PATH $REF_PATH
	else
		break # no more delta files
	fi
done



if [ -d "$REF_PATH/tce" ] && [ -d "$REF_PATH/mm" ]
then
	# This is an old appliance backup and we need to copy 
	# the relative data in correct places.
	# We assume that named and isc have already been correctly been 
	# setup for Micetro

	# 1. Copy preference files.
	cp -f $REF_PATH/mm/var/mmsuite/updater/preferences.cfg /var/mmsuite/updater/preferences.cfg
	chown root:root /var/mmsuite/updater/preferences.cfg
	cp -f $REF_PATH/mm/var/mmsuite/dhcp_server_controller/preferences.cfg /var/mmsuite/dhcp_server_controller/preferences.cfg
	chown root:root /var/mmsuite/dhcp_server_controller/preferences.cfg
	cp -f $REF_PATH/mm/var/cache/bind/mmsuite/preferences.cfg /var/mmsuite/dns_server_controller/preferences.cfg
	chown named:named /var/mmsuite/dns_server_controller/preferences.cfg

	# 2. BIND configuration files.
	chown -R named:named $REF_PATH/mm/var/cache/bind
	# clean out the mmsuite directory we don't want the old setup
	rm -rf $REF_PATH/mm/var/cache/bind/mmsuite

	rm -rf /replicated/jail/named/var/cache/bind.bak
	mv -f /replicated/jail/named/var/cache/bind /replicated/jail/named/var/cache/bind.bak
	mv -f $REF_PATH/mm/var/cache/bind /replicated/jail/named/var/cache/
	cp -f $REF_PATH/mm/var/cache/bind/conf/rndc.key /replicated/etc/rndc.conf
	chown root:root /replicated/etc/rndc.conf	
	
	# 3. ISC DHCP config.
	chown -R root:root $REF_PATH/mm/var/mmsuite/dhcp_server_controller/data
	mv -f /replicated/etc/dhcpd.conf /replicated/etc/dhcpd.conf.bak
	cp -f $REF_PATH/mm/var/mmsuite/dhcp_server_controller/data/dhcpd.conf /replicated/etc/dhcpd.conf
	mv -f /replicated/var/state/dhcp/dhcpd.leases /replicated/var/state/dhcp/dhcpd.leases.bak
	cp -f $REF_PATH/mm/var/mmsuite/dhcp_server_controller/data/dhcpd.leases /replicated/var/state/dhcp/dhcpd.leases

	# We might also want to restore some appliance config which we can find
	# in $REF_PATH/tce/mydata.tgz
else
	# rsync back to former location.
	rsync -a --log-file=/var/log/rsync.log $REF_PATH/* / 
fi

# Clean up. We simply remove the backup directory. It will be 
# recreated once the backup will start again.
rm -rf $DESTINATION

echo "Done restoring backup. Restarting the machine..."
reboot
